#include "Common.h"
#include "QSPI.h"
#include "halo_ports.h"

void quadspi_set_lut(uint32_t index, uint32_t value)
{
 	//Unlock the LUT
	do{
	QuadSPI_X.LUTKEY.R = 0x5AF05AF0;
	QuadSPI_X.LCKCR.R = 0x2;	//UNLOCK the LUT
	}
	while(QuadSPI_X.LCKCR.B.UNLOCK == 0); //is this required??
	
	// SEQID 2 - Page Erase
	QuadSPI_X.LUT[index].R = value; 	
	
	//Lock the LUT
	QuadSPI_X.LUTKEY.R = 0x5AF05AF0;
	QuadSPI_X.LCKCR.R = 0x1;	//LOCK the LUT
	while(QuadSPI_X.LCKCR.B.LOCK == 0);		
}

void QSPI_setup()
{
    uint32_t i;

  
  /* enable QuadSPI Clocks */
  /* using PLL0 to give 320MHz - this will give a SCK of 60MHz */
  
  MC_CGM.AC8_SC.B.SELCTL = 4; /* set PLL0 as source  */
  MC_CGM.AC8_DC0.R = 0x80020000; /* divide by 2 */

  //MC_CGM.AC9_SC.B.SELCTL = 4; /* set PLL0 as source  */
  //MC_CGM.AC9_DC0.R = 0x80010000; /* divide by 2 */


  SIUL2.MSCR[PH4].R = 0x32080001; //QSPI0_A_SCK
  SIUL2.MSCR[PH5].R = 0x320B0001; //QSPI0_A_CS1 w Pull up enabled
  SIUL2.MSCR[PH3].R = 0x32080001; //QSPI0_A_D3
  SIUL2.MSCR[PH2].R = 0x32080001; //QSPI0_A_D2
  SIUL2.MSCR[PH1].R = 0x32080001; //QSPI0_A_D1
  SIUL2.MSCR[PH0].R = 0x32080001; //QSPI0_A_D0

  SIUL2.MSCR[PH11].R = 0x32080001; //QSPI0_B_SCK
  SIUL2.MSCR[PH12].R = 0x320B0001; //QSPI0_B_CS1 w Pull up enabled
  SIUL2.MSCR[PH7].R =  0x32080001; //QSPI0_B_D3
  SIUL2.MSCR[PH8].R =  0x32080001; //QSPI0_B_D2
  SIUL2.MSCR[PH9].R =  0x32080001; //QSPI0_B_D1
  SIUL2.MSCR[PH10].R = 0x32080001; //QSPI0_B_D0

  
  //configure QuadSPI_X
  QuadSPI_X.MCR.B.DDR_EN = 1;
  QuadSPI_X.MCR.B.MDIS = 0; //clear MDIS bit
  QuadSPI_X.BUF0IND.R = 0x0; //set AHB buffer size (64bits)
  QuadSPI_X.SFA1AD.R = FLASH_BASE_ADR + 0x4000000; //set top address of FA1 (size 512Mbit)
  QuadSPI_X.SFA2AD.R = FLASH_BASE_ADR + 0x4000000;  //set top address of FA2 (size 0Mbit)
  QuadSPI_X.SFB1AD.R = FLASH_BASE_ADR2 + 0x4000000;  //set top address of FB1 (size 512Mbit)
  QuadSPI_X.SFB2AD.R = FLASH_BASE_ADR2 + 0x4000000;  //set top address of FB2 (size 0Mbit) 0x203FFFFF
                               
  setup_LUT_Q0(); //configure the lookup table
 
    
  QuadSPI_X.BUF0IND.R = 0x200; /* buffer0 size 256 bytes */ 
  QuadSPI_X.BUF1IND.R = 0x200; /* buffer1 size 256 bytes */ 
  QuadSPI_X.BUF2IND.R = 0x200; /* buffer2 size 0 bytes */ 
  /* leaves 0x0bytes for Buffer 3... */
  QuadSPI_X.BUF0CR.R = 0xA;/* dma1 on buffer 0 */
  //QuadSPI_X.BUF1CR.R = 0xA;/* dc5 on buffer 1 */
  QuadSPI_X.BUF3CR.R = 0x80000000;/* All others use buffer 3 */

  
  QuadSPI_X.MCR.R |= QuadSPI_MCR_CLR_TXF_MASK;
  QuadSPI_X.SFAR.R = FLASH_BASE_ADR;
  quadspi_enable_quad_bit();
  QuadSPI_X.SFAR.R = FLASH_BASE_ADR;  

  QuadSPI_X.SFAR.R = FLASH_BASE_ADR2;
  quadspi_enable_quad_bit();  
  QuadSPI_X.SFAR.R = FLASH_BASE_ADR2;

  QuadSPI_X.SFAR.R = FLASH_BASE_ADR;
  /* set QuadDDR as XBAR read instruction */
  //QuadSPI_X.BFGENCR.R = 0x08000; //use QUAD DDR instructions
  //QuadSPI_X.BFGENCR.B.PAR_EN = 0; //set parallel bit
  
	quadspi_set_lut(32,0x2A1804ED); 
	quadspi_set_lut(33,0x0E072E00); 
	quadspi_set_lut(34,0x24003A80); 	  
  
	QuadSPI_X.BFGENCR.R = 8<<12;
  
    QuadSPI_X.MCR.B.MDIS = 1;
	QuadSPI_X.SMPR.B.DDRSMP = 2;
	QuadSPI_X.MCR.B.MDIS = 0;

} /* QSPI_setup */


void setup_LUT_Q0()
{
    /* Setup LUT */
  //Unlock the LUT
  QuadSPI_X.LUTKEY.R = 0x5AF05AF0;
  QuadSPI_X.LCKCR.R = 0x2;	//UNLOCK the LUT
  while(QuadSPI_X.LCKCR.B.UNLOCK == 0); //is this required??
  //program required commands 
  // SEQID 0 - Quad Read 
  // SEQID 1 - exit from continuous mode
  //QuadSPI_X.LUT[0].B.INSTR0 = CMD;
  //QuadSPI_X.LUT[0].B.PAD0 = 0;
  //QuadSPI_X.LUT[0].B.OPRND0 = 0xFF;
  // SEQID 1 - Write enable 
  QuadSPI_X.LUT[4].R = 0x406;
  // SEQID 2 - Bulk Erase 
  QuadSPI_X.LUT[8].R = 0x460; 
  // SEQID 3 - Read Status 
  QuadSPI_X.LUT[12].R = 0x1c010405;
  // SEQID 4 - Page Program 
  QuadSPI_X.LUT[16].R = 0x08180402; // 24bit address 
  QuadSPI_X.LUT[17].R = 0x2004; // default 4-byte write 
  // SEQID 5 - Write Config/Status 
  QuadSPI_X.LUT[20].R = 0x20020401; //2-byte write 
  // SEQID 6 - Read Config 
  QuadSPI_X.LUT[24].R = 0x1c010435; //1-byte read 

  // SEQID 7 - Quad SDR Read
  //Quad DDR read, 24bit address
  QuadSPI_X.LUT[28].B.INSTR0 = CMD;
  QuadSPI_X.LUT[28].B.PAD0 = 0;
  QuadSPI_X.LUT[28].B.OPRND0 = 0xEB;
  QuadSPI_X.LUT[28].B.INSTR1 = ADDR;
  QuadSPI_X.LUT[28].B.PAD1 = 0x2;
  QuadSPI_X.LUT[28].B.OPRND1 = 0x18;
  //1mode bit and 6 dummy cycles
  QuadSPI_X.LUT[29].B.INSTR0 = MODE;
  QuadSPI_X.LUT[29].B.PAD0 = 2;
  QuadSPI_X.LUT[29].B.OPRND0 = 0xa5;
  QuadSPI_X.LUT[29].B.INSTR1 = DUMMY;
  QuadSPI_X.LUT[29].B.PAD1 = 0x2;
  QuadSPI_X.LUT[29].B.OPRND1 = 0x4;
  //read 128 bytes
  QuadSPI_X.LUT[30].B.INSTR0 = READ;
  QuadSPI_X.LUT[30].B.PAD0 = 2;
  QuadSPI_X.LUT[30].B.OPRND0 = 0x80;
  QuadSPI_X.LUT[30].B.INSTR1 = JMP_ON_CS;
  QuadSPI_X.LUT[30].B.PAD1 = 0;
  QuadSPI_X.LUT[30].B.OPRND1 = 1;
  
  // SEQID 8 - Quad DDR Read
  //Quad DDR read, 24bit address
  QuadSPI_X.LUT[32].B.INSTR0 = CMD;
  QuadSPI_X.LUT[32].B.PAD0 = 0;
  QuadSPI_X.LUT[32].B.OPRND0 = 0xED;
  QuadSPI_X.LUT[32].B.INSTR1 = ADDR_DDR;
  QuadSPI_X.LUT[32].B.PAD1 = 0x2;
  QuadSPI_X.LUT[32].B.OPRND1 = 0x18;
  //1mode bit and 6 dummy cycles
  QuadSPI_X.LUT[33].B.INSTR0 = MODE_DDR;
  QuadSPI_X.LUT[33].B.PAD0 = 2;
  QuadSPI_X.LUT[33].B.OPRND0 = 0x00;
  QuadSPI_X.LUT[33].B.INSTR1 = DUMMY;
  QuadSPI_X.LUT[33].B.PAD1 = 0x2;
  QuadSPI_X.LUT[33].B.OPRND1 = 0x7;
  //read 128 bytes
  QuadSPI_X.LUT[34].B.INSTR0 = READ_DDR;
  QuadSPI_X.LUT[34].B.PAD0 = 2;
  QuadSPI_X.LUT[34].B.OPRND0 = 0x80;
  QuadSPI_X.LUT[34].B.INSTR1 = JMP_ON_CS;
  QuadSPI_X.LUT[34].B.PAD1 = 0;
  QuadSPI_X.LUT[34].B.OPRND1 = 0;
  // SEQID 11 - RDIDJ (get part details)  
  QuadSPI_X.LUT[44].B.INSTR0 = CMD;
  QuadSPI_X.LUT[44].B.PAD0 = 0;
  QuadSPI_X.LUT[44].B.OPRND0 = 0x9F;
  QuadSPI_X.LUT[44].B.INSTR1 = READ;
  QuadSPI_X.LUT[44].B.PAD1 = 0;
  QuadSPI_X.LUT[44].B.OPRND1 = 8;    
  //Lock the LUT
  QuadSPI_X.LUTKEY.R = 0x5AF05AF0;
  QuadSPI_X.LCKCR.R = 0x1;	//LOCK the LUT
  while(QuadSPI_X.LCKCR.B.LOCK == 0);
}

void quadspi_wait_while_flash_busy()
{
  uint32_t status_value = 0x1;
  while ((status_value & 0x1)==0x1)
  { 
    QuadSPI_X.IPCR.R = 3 << 24;
    while(QuadSPI_X.SR.R & QuadSPI_SR_BUSY_MASK);
    while((QuadSPI_X.SR.R & 0x00010000)==0);
    status_value = ARDB; 
    QuadSPI_X.FR.R = 0x10000; /* read complete */
  }
}

void quadspi_enable_quad_bit(void)
{
   int i;
  //write enable 
  QuadSPI_X.IPCR.R = 1 << 24;
  while(QuadSPI_X.SR.R & QuadSPI_SR_BUSY_MASK);
  //write data to Tx Buffer
  QuadSPI_X.MCR.B.CLR_TXF = 1;
  for(i = 0; i<4; i++)
  {
      QuadSPI_X.FR.R = 0x08000000; 
      QuadSPI_X.TBDR.R = 0x00000200; //write status/config, enable flash quad mode
  }
  // send write command 
  QuadSPI_X.IPCR.R = ((5 << 24));
  while(QuadSPI_X.SR.R & QuadSPI_SR_BUSY_MASK);
  quadspi_wait_while_flash_busy();
  // Read config reg to ensure write was successful 
  QuadSPI_X.IPCR.R = (6 << 24); 
  while(QuadSPI_X.SR.R & QuadSPI_SR_BUSY_MASK);
  QuadSPI_X.FR.R = 0x10000; /* read complete */
}

void quadspi_eraseA(void)
{
  QuadSPI_X.SFAR.R = FLASH_BASE_ADR; 
  //write enable 
  QuadSPI_X.IPCR.R = 1 << 24;
  while(QuadSPI_X.SR.R & QuadSPI_SR_BUSY_MASK);
  //send erase command 
  QuadSPI_X.IPCR.R = 2 << 24;
  while(QuadSPI_X.SR.R & QuadSPI_SR_BUSY_MASK);
  quadspi_wait_while_flash_busy();  
}

void quadspi_eraseB(void)
{
  QuadSPI_X.SFAR.R = FLASH_BASE_ADR2; 
  //write enable 
  QuadSPI_X.IPCR.R = 1 << 24;
  while(QuadSPI_X.SR.R & QuadSPI_SR_BUSY_MASK);
  //send erase command 
  QuadSPI_X.IPCR.R = 2 << 24;
  while(QuadSPI_X.SR.R & QuadSPI_SR_BUSY_MASK);
  quadspi_wait_while_flash_busy();  
}

void quadspi_program(unsigned long src, unsigned long base, unsigned long size)
{
	unsigned int *start_address = (unsigned int *)src;
	unsigned int *end_address = (unsigned int *)(src + size);
	unsigned int *page_address = start_address;
	unsigned int *flash_address = (unsigned int *)base;
	int page_size = FLASH_PGSZ;
	unsigned int *current_address = start_address;
        unsigned int data_value;
	int i;

	// 1024 offset for spansion
	QuadSPI_X.SFAR.R = (unsigned int)flash_address;
	QuadSPI_X.MCR.R |= QuadSPI_MCR_CLR_TXF_MASK;
	
	page_address = start_address + (page_size >> 2);

	while (page_address <= end_address)
	{
		// write enable 
		QuadSPI_X.IPCR.R = 1 << 24;
		while(QuadSPI_X.SR.R & QuadSPI_SR_BUSY_MASK); 
		QuadSPI_X.MCR.R |= QuadSPI_MCR_CLR_TXF_MASK;

		while (current_address < page_address)
		{
			// fill tx fifo (64 bytes)
			for (i = 0; i < 16; i++)
			{
			  data_value=*(current_address++);
			  QuadSPI_X.TBDR.R = byte_swap32(data_value);
			}
	
			QuadSPI_X.IPCR.R = (4 << 24) | page_size; //page program 256bytes 
/*
			for (i = 0; i < 48; i++)
			{
				while(QuadSPI_X.SR.R & 0x08000000);
				data_value=*(current_address++);
				QuadSPI_X.TBDR.R = byte_swap32(data_value);
			}
*/
			while(QuadSPI_X.SR.R & QuadSPI_SR_BUSY_MASK);
			quadspi_wait_while_flash_busy(); 
	
		}
		page_address += (page_size >> 2);
		flash_address += (page_size >> 2);
		QuadSPI_X.SFAR.R = (unsigned int)flash_address;
	}
}

void quadspi_programA(unsigned long src, unsigned long base, unsigned long size)
{
	unsigned int *start_address = (unsigned int *)src;
	unsigned int *end_address = (unsigned int *)(src + size);
	unsigned int *page_address = start_address;
	unsigned int *flash_address = (unsigned int *)base;
	int page_size = FLASH_PGSZ;
	unsigned int *current_address = start_address;
        unsigned int *current_address1 = start_address;
        unsigned int data_value;
        unsigned int data_value2;
	int i;

	// 1024 offset for spansion
	QuadSPI_X.SFAR.R = (unsigned int)flash_address;
	QuadSPI_X.MCR.R |= QuadSPI_MCR_CLR_TXF_MASK;
	
	page_address = start_address + (page_size >> 2);

	while (page_address <= end_address)
	{
		// write enable 
		QuadSPI_X.IPCR.R = 1 << 24;
		while(QuadSPI_X.SR.R & QuadSPI_SR_BUSY_MASK); 
		QuadSPI_X.MCR.R |= QuadSPI_MCR_CLR_TXF_MASK;

		while (current_address < page_address)
		{
			// fill tx fifo (64 bytes)
			for (i = 0; i < 16; i++)
                        {
                          current_address++;
                          data_value=*(current_address1++);
                          data_value2=*(current_address1++);
                          QuadSPI_X.TBDR.R = byte_swap32A(data_value,data_value2);
                        }
	
			QuadSPI_X.IPCR.R = (4 << 24) | page_size; //page program 256bytes 
                        /*
			for (i = 0; i < 48; i++)
			{
				while(QuadSPI_X.SR.R & QuadSPI_SR_TXFULL_MASK);
                                current_address++;
                                data_value=*(current_address1++);
                                data_value2=*(current_address1++);
				QuadSPI_X.TBDR.R = byte_swap32A(data_value,data_value2);
			}
                        */
			while(QuadSPI_X.SR.R & QuadSPI_SR_BUSY_MASK);
			quadspi_wait_while_flash_busy(); 
	
		}
		page_address += (page_size >> 2);
		flash_address += (page_size >> 2);
		QuadSPI_X.SFAR.R = (unsigned int)flash_address;
	}
}

void quadspi_programB(unsigned long src, unsigned long base, unsigned long size)
{
	unsigned int *start_address = (unsigned int *)src;
	unsigned int *end_address = (unsigned int *)(src + size);
	unsigned int *page_address = start_address;
	unsigned int *flash_address = (unsigned int *)base;
	int page_size = FLASH_PGSZ;
	unsigned int *current_address = start_address;
        unsigned int *current_address1 = start_address;
        unsigned int data_value;
        unsigned int data_value2;
	int i;

	// 1024 offset for spansion
	QuadSPI_X.SFAR.R = (unsigned int)flash_address;
	QuadSPI_X.MCR.R |= QuadSPI_MCR_CLR_TXF_MASK;
	
	page_address = start_address + (page_size >> 2);

	while (page_address <= end_address)
	{
		// write enable 
		QuadSPI_X.IPCR.R = 1 << 24;
		while(QuadSPI_X.SR.R & QuadSPI_SR_BUSY_MASK); 
		QuadSPI_X.MCR.R |= QuadSPI_MCR_CLR_TXF_MASK;

		while (current_address < page_address)
		{
			// fill tx fifo (64 bytes)
			for (i = 0; i < 16; i++)
                        {
                          current_address++;
                          data_value=*(current_address1++);
                          data_value2=*(current_address1++);
                          QuadSPI_X.TBDR.R = byte_swap32B(data_value,data_value2);
                        }
	
			QuadSPI_X.IPCR.R = (4 << 24) | page_size; //page program 256bytes 
                        /*
			for (i = 0; i < 48; i++)
			{
				while(QuadSPI_X.SR.R & QuadSPI_SR_TXFULL_MASK);
                                current_address++;
                                data_value=*(current_address1++);
                                data_value2=*(current_address1++);
				QuadSPI_X.TBDR.R = byte_swap32B(data_value,data_value2);
			}
                        */
			while(QuadSPI_X.SR.R & QuadSPI_SR_BUSY_MASK);
			quadspi_wait_while_flash_busy(); 
	
		}
		page_address += (page_size >> 2);
		flash_address += (page_size >> 2);
		QuadSPI_X.SFAR.R = (unsigned int)flash_address;
	}
}
